<!DOCTYPE html>
<html lang="hr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php echo htmlspecialchars($user['ime'] . ' ' . $user['prezime']); ?></title>
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body {
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
      background: <?php echo $bgStyle; ?>;
      min-height: 100vh;
      padding: 20px;
      display: flex;
      justify-content: center;
      align-items: center;
    }
    
    .card-container {
      background: white;
      border-radius: 20px;
      box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
      max-width: 450px;
      width: 100%;
      overflow: hidden;
    }
    
    .card-header {
      background: <?php echo $bgStyle; ?>;
      padding: 40px 30px;
      text-align: center;
      color: white;
      position: relative;
    }
    
    .profile-image {
      width: 120px;
      height: 120px;
      border-radius: 50%;
      border: 5px solid white;
      object-fit: cover;
      margin-bottom: 20px;
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }
    
    .profile-placeholder {
      width: 120px;
      height: 120px;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.2);
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 48px;
      margin: 0 auto 20px;
      border: 5px solid white;
      font-weight: 700;
    }
    
    .card-name { 
      font-size: 28px; 
      font-weight: 700; 
      margin-bottom: 10px;
      text-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    .card-description { 
      font-size: 16px; 
      opacity: 0.95; 
      line-height: 1.5;
    }
    
    .card-body { padding: 30px; }
    
    .save-contact-btn {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 12px;
      width: 100%;
      padding: 16px;
      background: <?php echo $bgStyle; ?>;
      color: white;
      border: none;
      border-radius: 12px;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      margin-bottom: 25px;
      transition: all 0.3s ease;
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }
    
    .save-contact-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(0,0,0,0.2);
    }
    
    .save-contact-btn svg {
      width: 24px;
      height: 24px;
    }
    
    .contact-grid { 
      display: grid; 
      gap: 12px; 
      margin-bottom: 25px;
    }
    
    .contact-item {
      display: flex;
      align-items: center;
      gap: 15px;
      padding: 15px;
      background: #f8f9ff;
      border-radius: 12px;
      color: #333;
      text-decoration: none;
      transition: all 0.3s ease;
      border: 2px solid transparent;
    }
    
    .contact-item:hover { 
      background: #eef0ff; 
      transform: translateX(5px);
      border-color: rgba(102, 126, 234, 0.3);
    }
    
    .contact-icon {
      width: 44px;
      height: 44px;
      min-width: 44px;
      border-radius: 10px;
      display: flex;
      align-items: center;
      justify-content: center;
      flex-shrink: 0;
    }
    
    .contact-icon svg {
      width: 24px;
      height: 24px;
    }
    
    .social-links {
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 12px;
      padding: 20px 0;
    }
    
    .social-link {
      width: 50px;
      height: 50px;
      border-radius: 12px;
      background: #f8f9ff;
      display: flex;
      align-items: center;
      justify-content: center;
      text-decoration: none;
      transition: all 0.3s ease;
    }
    
    .social-link:hover {
      transform: translateY(-4px) scale(1.05);
      box-shadow: 0 8px 16px rgba(0,0,0,0.15);
    }
    
    .social-link svg {
      width: 26px;
      height: 26px;
    }
    
    .map-container {
      margin-top: 30px;
      border-radius: 12px;
      overflow: hidden;
      height: 280px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    
    .instagram-section {
      margin-top: 30px;
      padding: 25px;
      background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
      border-radius: 12px;
      text-align: center;
    }
    
    .instagram-section h3 {
      color: white;
      font-size: 18px;
      margin-bottom: 15px;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
    }
    
    .instagram-btn {
      display: inline-flex;
      align-items: center;
      gap: 10px;
      padding: 12px 24px;
      background: white;
      color: #f5576c;
      border-radius: 10px;
      text-decoration: none;
      font-weight: 600;
      transition: all 0.3s;
    }
    
    .instagram-btn:hover {
      transform: scale(1.05);
      box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    
    .address-info {
      margin-top: 25px;
      padding: 20px;
      background: #f8f9ff;
      border-radius: 12px;
    }
    
    .address-info h4 {
      color: #333;
      margin-bottom: 12px;
      font-size: 16px;
      display: flex;
      align-items: center;
      gap: 8px;
    }
    
    .address-text {
      color: #555;
      line-height: 1.6;
    }
    
    @media (max-width: 480px) {
      body { padding: 10px; }
      .card-header { padding: 30px 20px; }
      .card-body { padding: 20px; }
      .card-name { font-size: 24px; }
      .social-links { gap: 8px; }
      .social-link { width: 46px; height: 46px; }
    }
  </style>
</head>
<body>
  <div class="card-container">
    <div class="card-header">
      <?php if ($user['slika']): ?>
        <img src="<?php echo htmlspecialchars($user['slika']); ?>" alt="<?php echo htmlspecialchars($user['ime']); ?>" class="profile-image">
      <?php else: ?>
        <div class="profile-placeholder">
          <?php echo mb_strtoupper(mb_substr($user['ime'], 0, 1) . mb_substr($user['prezime'], 0, 1)); ?>
        </div>
      <?php endif; ?>
      
      <h1 class="card-name"><?php echo htmlspecialchars($user['ime'] . ' ' . $user['prezime']); ?></h1>
      <?php if ($user['opis']): ?>
        <p class="card-description"><?php echo nl2br(htmlspecialchars($user['opis'])); ?></p>
      <?php endif; ?>
    </div>
    
    <div class="card-body">
      <?php if (isset($activeModules['vcard'])): ?>
        <button class="save-contact-btn" onclick="downloadVCard()">
          <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3 3m0 0l-3-3m3 3V4"/>
          </svg>
          Spremi kontakt u imenik
        </button>
      <?php endif; ?>
      
      <div class="contact-grid">
        <?php if ($user['telefon']): ?>
          <a href="tel:<?php echo htmlspecialchars($user['telefon']); ?>" class="contact-item">
            <div class="contact-icon" style="background: #10b981;">
              <svg fill="white" viewBox="0 0 24 24">
                <path d="M20.01 15.38c-1.23 0-2.42-.2-3.53-.56a.977.977 0 00-1.01.24l-1.57 1.97c-2.83-1.35-5.48-3.9-6.89-6.83l1.95-1.66c.27-.28.35-.67.24-1.02-.37-1.11-.56-2.3-.56-3.53 0-.54-.45-.99-.99-.99H4.19C3.65 3 3 3.24 3 3.99 3 13.28 10.73 21 20.01 21c.71 0 .99-.63.99-1.18v-3.45c0-.54-.45-.99-.99-.99z"/>
              </svg>
            </div>
            <div><?php echo htmlspecialchars($user['telefon']); ?></div>
          </a>
        <?php endif; ?>
        
        <?php if ($user['email']): ?>
          <a href="mailto:<?php echo htmlspecialchars($user['email']); ?>" class="contact-item">
            <div class="contact-icon" style="background: #3b82f6;">
              <svg fill="white" viewBox="0 0 24 24">
                <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
              </svg>
            </div>
            <div style="word-break: break-all;"><?php echo htmlspecialchars($user['email']); ?></div>
          </a>
        <?php endif; ?>
        
        <?php if ($user['whatsapp']): ?>
          <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $user['whatsapp']); ?>" class="contact-item" target="_blank">
            <div class="contact-icon" style="background: #25D366;">
              <svg fill="white" viewBox="0 0 24 24">
                <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
              </svg>
            </div>
            <div>WhatsApp</div>
          </a>
        <?php endif; ?>
        
        <?php if ($user['viber']): ?>
          <a href="viber://chat?number=<?php echo preg_replace('/[^0-9+]/', '', $user['viber']); ?>" class="contact-item">
            <div class="contact-icon" style="background: #7360f2;">
              <svg fill="white" viewBox="0 0 24 24">
                <path d="M11.4 0C9.473.028 5.333.344 3.02 2.467 1.302 4.187.696 6.7.633 9.817.57 12.933.488 18.776 6.12 20.36h.003l-.004 2.644s-.037.977.61 1.177c.777.242 1.234-.5 1.98-1.302.407-.44.97-1.084 1.396-1.58 3.85.323 6.812-.417 7.15-.525.776-.253 5.176-.816 5.892-6.657.74-6.02-.36-9.83-2.34-11.546 0 0-1.915-2.5-7.398-2.388zM11.45 1.62c4.817-.095 6.545 1.857 6.545 1.857 1.725 1.494 2.674 4.8 2.003 10.158-.629 5.023-4.477 5.383-5.14 5.604-.297.098-2.697.732-6.123.498 0 0-2.427 2.93-3.19 3.698-.12.12-.26.167-.352.145-.13-.03-.166-.18-.165-.396l.02-4.426c-4.71-1.31-4.418-6.27-4.363-8.9.053-2.61.567-4.733 1.99-6.28C4.724 1.646 8.28 1.668 11.45 1.62zm.12 2.15c-.397.006-.397.595 0 .602 3.225.034 5.85 2.447 6.035 5.535.027.396.61.37.583-.03-.213-3.438-3.14-6.14-6.618-6.107zm-3.87 1.19c-.268-.01-.593.02-.88.154-.96.448-1.48 1.148-1.48 1.148-.33.385-.428.867-.426 1.42.003.773.196 1.676.596 2.67.78 1.943 2.11 3.885 3.528 5.305 1.418 1.42 3.36 2.748 5.303 3.528.994.4 1.897.593 2.67.596.553.002 1.035-.096 1.42-.426 0 0 .7-.52 1.148-1.48.318-.683.072-1.22-.422-1.545l-1.67-1.104c-.456-.304-1.086-.168-1.386.25 0 0-.502.636-.772.927-.267.29-.65.23-.65.23-2.77-.735-4.97-2.933-5.705-5.705 0 0-.06-.383.23-.65.29-.27.927-.772.927-.772.418-.3.554-.93.25-1.386l-1.104-1.67c-.23-.347-.596-.52-.977-.53z"/>
              </svg>
            </div>
            <div>Viber</div>
          </a>
        <?php endif; ?>
      </div>
      
      <?php if ($user['adresa'] || $user['grad'] || $user['drzava']): ?>
        <div class="address-info">
          <h4>
            <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
            </svg>
            Adresa
          </h4>
          <div class="address-text">
            <?php 
            $addressParts = array_filter([
              $user['adresa'],
              $user['grad'],
              $user['drzava']
            ]);
            echo implode('<br>', array_map('htmlspecialchars', $addressParts));
            ?>
          </div>
        </div>
      <?php endif; ?>
      
      <?php if (count($links) > 0): ?>
        <div class="social-links">
          <?php 
          $socialIcons = [
            'facebook' => '<svg fill="#1877f2" viewBox="0 0 24 24"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>',
            'instagram' => '<svg fill="#E4405F" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg>',
            'linkedin' => '<svg fill="#0077b5" viewBox="0 0 24 24"><path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/></svg>',
            'twitter' => '<svg fill="#1DA1F2" viewBox="0 0 24 24"><path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/></svg>',
            'youtube' => '<svg fill="#FF0000" viewBox="0 0 24 24"><path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/></svg>',
            'website' => '<svg fill="#6366f1" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z"/></svg>',
            'tiktok' => '<svg fill="#000000" viewBox="0 0 24 24"><path d="M12.525.02c1.31-.02 2.61-.01 3.91-.02.08 1.53.63 3.09 1.75 4.17 1.12 1.11 2.7 1.62 4.24 1.79v4.03c-1.44-.05-2.89-.35-4.2-.97-.57-.26-1.1-.59-1.62-.93-.01 2.92.01 5.84-.02 8.75-.08 1.4-.54 2.79-1.35 3.94-1.31 1.92-3.58 3.17-5.91 3.21-1.43.08-2.86-.31-4.08-1.03-2.02-1.19-3.44-3.37-3.65-5.71-.02-.5-.03-1-.01-1.49.18-1.9 1.12-3.72 2.58-4.96 1.66-1.44 3.98-2.13 6.15-1.72.02 1.48-.04 2.96-.04 4.44-.99-.32-2.15-.23-3.02.37-.63.41-1.11 1.04-1.36 1.75-.21.51-.15 1.07-.14 1.61.24 1.64 1.82 3.02 3.5 2.87 1.12-.01 2.19-.66 2.77-1.61.19-.33.4-.67.41-1.06.1-1.79.06-3.57.07-5.36.01-4.03-.01-8.05.02-12.07z"/></svg>'
          ];
          
          foreach ($links as $link):
          ?>
            <a href="<?php echo htmlspecialchars($link['url']); ?>" target="_blank" class="social-link" title="<?php echo ucfirst($link['tip']); ?>">
              <?php echo $socialIcons[$link['tip']] ?? '<svg fill="#667eea" viewBox="0 0 24 24"><path d="M3.9 12c0-1.71 1.39-3.1 3.1-3.1h4V7H7c-2.76 0-5 2.24-5 5s2.24 5 5 5h4v-1.9H7c-1.71 0-3.1-1.39-3.1-3.1zM8 13h8v-2H8v2zm9-6h-4v1.9h4c1.71 0 3.1 1.39 3.1 3.1s-1.39 3.1-3.1 3.1h-4V17h4c2.76 0 5-2.24 5-5s-2.24-5-5-5z"/></svg>'; ?>
            </a>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
      
      <?php if (isset($activeModules['mapa']) && $activeModules['mapa']['config']): ?>
        <?php 
        $mapConfig = json_decode($activeModules['mapa']['config'], true);
        $mapLink = $mapConfig['link'] ?? '';
        
        // Provjeri je li Google Maps share link
        if (strpos($mapLink, 'maps.app.goo.gl') !== false || strpos($mapLink, 'google.com/maps') !== false) {
          // Embed Google Maps iframe
          if (strpos($mapLink, 'maps.app.goo.gl') !== false) {
            // Kratki link - koristi kao search
            echo '<div class="map-container">';
            echo '<iframe src="https://maps.google.com/maps?q=' . urlencode($mapLink) . '&output=embed" width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"></iframe>';
            echo '</div>';
          } else {
            // Puni Google Maps link
            echo '<div class="map-container">';
            echo '<iframe src="' . htmlspecialchars($mapLink) . '" width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"></iframe>';
            echo '</div>';
          }
        } else {
          // Naziv lokacije - search
          echo '<div class="map-container">';
          echo '<iframe src="https://maps.google.com/maps?q=' . urlencode($mapLink) . '&output=embed" width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"></iframe>';
          echo '</div>';
        }
        ?>
      <?php endif; ?>
      
      <?php if (isset($activeModules['instagram_feed']) && $activeModules['instagram_feed']['config']): ?>
        <?php $igConfig = json_decode($activeModules['instagram_feed']['config'], true); ?>
        <div class="instagram-section">
          <h3>
            <svg width="24" height="24" fill="white" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg>
            Instagram
          </h3>
          <a href="https://instagram.com/<?php echo htmlspecialchars($igConfig['username']); ?>" 
             target="_blank" 
             class="instagram-btn">
            <svg width="20" height="20" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069z"/></svg>
            @<?php echo htmlspecialchars($igConfig['username']); ?>
          </a>
        </div>
      <?php endif; ?>
    </div>
  </div>
  
        <!-- Branding -->
      <div class="branding">
        Made with <a href="https://taptap.ba" target="_blank">TapTap</a> • Powered by <a href="https://convoco.co" target="_blank">Convoco</a>
      </div>
    </div>
  </div>
  
<?php if (isset($activeModules['vcard']) || isset($activeModules['qr_code'])): ?>
  <div class="footer">
    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 0;">
      <?php if (isset($activeModules['vcard'])): ?>
        <button class="footer-btn" onclick="downloadVCard()" style="border-right: 1px solid rgba(255,255,255,0.2);">
          <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3 3m0 0l-3-3m3 3V4"/>
          </svg>
          Spremi kontakt
        </button>
      <?php endif; ?>
      
      <?php if (isset($activeModules['qr_code'])): ?>
        <button class="footer-btn" onclick="toggleQR()">
          <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v1m6 11h2m-6 0h-2v4m0-11v3m0 0h.01M12 12h4.01M16 20h4M4 12h4m12 0h.01M5 8h2a1 1 0 001-1V5a1 1 0 00-1-1H5a1 1 0 00-1 1v2a1 1 0 001 1zm12 0h2a1 1 0 001-1V5a1 1 0 00-1-1h-2a1 1 0 00-1 1v2a1 1 0 001 1zM5 20h2a1 1 0 001-1v-2a1 1 0 00-1-1H5a1 1 0 00-1 1v2a1 1 0 001 1z"/>
          </svg>
          Prikaži QR kod
        </button>
      <?php endif; ?>
    </div>
  </div>

  <!-- QR Code Modal -->
  <?php if (isset($activeModules['qr_code'])): ?>
    <div id="qrModal" class="qr-modal" onclick="toggleQR()">
      <div class="qr-modal-content" onclick="event.stopPropagation()">
        <button class="qr-close" onclick="toggleQR()">×</button>
        <h3 style="text-align: center; margin-bottom: 20px; color: #333;">Skeniraj QR kod</h3>
        <div style="text-align: center; padding: 20px; background: white; border-radius: 12px;">
          <img src="https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=<?php echo urlencode('https://' . $_SERVER['HTTP_HOST'] . '/' . $user['slug'] . '?qr=1'); ?>" 
               alt="QR Code" 
               style="max-width: 100%; height: auto; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
        </div>
        <p style="text-align: center; margin-top: 15px; color: #666; font-size: 14px;">
          Skeniraj ovaj kod da spremiš kontakt
        </p>
      </div>
    </div>
  <?php endif; ?>
<?php endif; ?>

<style>
.footer {
  position: fixed;
  bottom: 0;
  left: 0;
  right: 0;
  background: white;
  border-top: 1px solid #e5e7eb;
  box-shadow: 0 -4px 12px rgba(0,0,0,0.05);
  z-index: 100;
}

.footer-btn {
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 10px;
  padding: 16px;
  background: var(--accent, #667eea);
  color: white;
  border: none;
  font-size: 15px;
  font-weight: 600;
  cursor: pointer;
  transition: all 0.2s;
}

.footer-btn:hover {
  background: var(--accent-hover, #5568d3);
}

.footer-btn:active {
  transform: scale(0.98);
}

.footer-btn svg {
  width: 20px;
  height: 20px;
}

.qr-modal {
  display: none;
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: rgba(0, 0, 0, 0.7);
  z-index: 1000;
  align-items: center;
  justify-content: center;
  padding: 20px;
}

.qr-modal.active {
  display: flex;
}

.qr-modal-content {
  background: #f8f9fa;
  padding: 30px;
  border-radius: 20px;
  max-width: 400px;
  width: 100%;
  position: relative;
  box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
}

.qr-close {
  position: absolute;
  top: 15px;
  right: 15px;
  background: rgba(0, 0, 0, 0.1);
  border: none;
  width: 35px;
  height: 35px;
  border-radius: 50%;
  font-size: 24px;
  cursor: pointer;
  color: #333;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.2s;
}

.qr-close:hover {
  background: rgba(0, 0, 0, 0.2);
  transform: rotate(90deg);
}

/* Dodaj padding-bottom na body da footer ne prekrije sadržaj */
body {
  padding-bottom: 70px;
}

@media (max-width: 480px) {
  .footer-btn {
    font-size: 13px;
    padding: 14px;
  }
  .qr-modal-content {
    padding: 25px;
  }
}
</style>

<script>
function toggleQR() {
  const modal = document.getElementById('qrModal');
  modal.classList.toggle('active');
}

function downloadVCard() {
  const vcard = `BEGIN:VCARD
VERSION:3.0
FN:<?php echo $user['ime'] . ' ' . $user['prezime']; ?>
N:<?php echo $user['prezime']; ?>;<?php echo $user['ime']; ?>;;;
TEL;TYPE=CELL:<?php echo $user['telefon'] ?? ''; ?>
EMAIL:<?php echo $user['email'] ?? ''; ?>
<?php if ($user['adresa']): ?>ADR;TYPE=WORK:;;<?php echo $user['adresa']; ?>;<?php echo $user['grad']; ?>;<?php echo $user['drzava']; ?><?php endif; ?>
NOTE:<?php echo str_replace(["\r\n", "\n", "\r"], ' ', $user['opis'] ?? ''); ?>
END:VCARD`;
  
  const blob = new Blob([vcard], { type: 'text/vcard' });
  const url = window.URL.createObjectURL(blob);
  const a = document.createElement('a');
  a.href = url;
  a.download = '<?php echo $user['ime'] . '_' . $user['prezime']; ?>.vcf';
  a.click();
  window.URL.revokeObjectURL(url);
}
</script>
</body>
</html>
  
  <script>
    function downloadVCard() {
      const vcard = `BEGIN:VCARD
VERSION:3.0
FN:<?php echo $user['ime'] . ' ' . $user['prezime']; ?>
N:<?php echo $user['prezime']; ?>;<?php echo $user['ime']; ?>;;;
TEL;TYPE=CELL:<?php echo $user['telefon'] ?? ''; ?>
EMAIL:<?php echo $user['email'] ?? ''; ?>
<?php if ($user['adresa']): ?>ADR;TYPE=WORK:;;<?php echo $user['adresa']; ?>;<?php echo $user['grad']; ?>;<?php echo $user['drzava']; ?><?php endif; ?>
NOTE:<?php echo str_replace(["\r\n", "\n", "\r"], ' ', $user['opis'] ?? ''); ?>
END:VCARD`;
      
      const blob = new Blob([vcard], { type: 'text/vcard' });
      const url = window.URL.createObjectURL(blob);
      const a = document.createElement('a');
      a.href = url;
      a.download = '<?php echo $user['ime'] . '_' . $user['prezime']; ?>.vcf';
      a.click();
      window.URL.revokeObjectURL(url);
    }
  </script>
</body>
</html>