<?php
// PHP auth logic može ići ovdje
?>
<!DOCTYPE html>
<html lang="hr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>TapTap Card Admin</title>
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body {
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
      background: #f5f7fa;
    }
    
    .login-container {
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      padding: 20px;
    }
    
    .login-box {
      background: white;
      padding: 40px;
      border-radius: 12px;
      box-shadow: 0 4px 20px rgba(0,0,0,0.1);
      width: 100%;
      max-width: 400px;
    }
    
    .login-box h2 { margin-bottom: 30px; color: #333; text-align: center; }
    .form-group { margin-bottom: 20px; position: relative; }
    
    label {
      display: block;
      margin-bottom: 8px;
      font-weight: 600;
      color: #555;
      font-size: 14px;
    }
    
    input, textarea, select {
      width: 100%;
      padding: 12px;
      border: 2px solid #e5e7eb;
      border-radius: 8px;
      font-size: 15px;
      transition: border 0.3s;
      font-family: inherit;
    }
    
    input[type="color"] {
      height: 50px;
      padding: 5px;
      cursor: pointer;
    }
    
    input:focus, textarea:focus, select:focus {
      outline: none;
      border-color: #667eea;
    }
    
    .password-wrapper {
      position: relative;
    }
    
    .password-wrapper input {
      padding-right: 45px;
    }
    
    .password-toggle {
      position: absolute;
      right: 12px;
      top: 50%;
      transform: translateY(-50%);
      background: none;
      border: none;
      cursor: pointer;
      font-size: 20px;
      color: #6b7280;
      padding: 5px;
    }
    
    .password-toggle:hover {
      color: #667eea;
    }
    
    textarea { resize: vertical; min-height: 100px; }
    
    .btn {
      width: 100%;
      padding: 14px;
      background: #667eea;
      color: white;
      border: none;
      border-radius: 8px;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      transition: background 0.3s;
    }
    
    .btn:hover { background: #5568d3; }
    .btn:disabled { background: #d1d5db; cursor: not-allowed; }
    .btn-secondary { background: #6b7280; }
    .btn-secondary:hover { background: #4b5563; }
    .btn-danger { background: #ef4444; }
    .btn-danger:hover { background: #dc2626; }
    .btn-small { width: auto; padding: 8px 16px; font-size: 14px; }
    
    .error-message, .success-message {
      padding: 12px;
      border-radius: 8px;
      margin-bottom: 15px;
    }
    
    .error-message {
      background: #fee;
      color: #c00;
    }
    
    .success-message {
      background: #d1fae5;
      color: #065f46;
    }
    
    .back-link {
      text-align: center;
      margin-top: 15px;
    }
    
    .back-link a {
      color: #667eea;
      text-decoration: none;
      font-size: 14px;
    }
    
    .back-link a:hover {
      text-decoration: underline;
    }
    
    /* Sav ostali CSS iz hybrid verzije... */
    .dashboard {
      max-width: 1400px;
      margin: 0 auto;
      padding: 20px;
    }
    
    .header {
      background: white;
      padding: 20px;
      border-radius: 12px;
      margin-bottom: 20px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }
    
    .header h1 { color: #333; font-size: 24px; display: flex; align-items: center; gap: 10px; }
    
    .tabs {
      display: flex;
      gap: 10px;
      margin-bottom: 20px;
    }
    
    .tab {
      padding: 12px 24px;
      background: white;
      border: 2px solid #e5e7eb;
      border-radius: 8px;
      cursor: pointer;
      font-weight: 600;
      color: #6b7280;
      transition: all 0.3s;
    }
    
    .tab:hover {
      background: #f8f9ff;
      border-color: #667eea;
    }
    
    .tab.active {
      background: #667eea;
      color: white;
      border-color: #667eea;
    }
    
    .tab-content {
      display: none;
    }
    
    .tab-content.active {
      display: block;
    }
    
    .card {
      background: white;
      padding: 30px;
      border-radius: 12px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }
    
    .filter-bar {
      background: white;
      padding: 15px;
      border-radius: 12px;
      margin-bottom: 20px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.05);
      display: flex;
      gap: 10px;
      align-items: center;
      flex-wrap: wrap;
    }
    
    .filter-bar input {
      flex: 1;
      min-width: 200px;
    }
    
    .users-table {
      background: white;
      border-radius: 12px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.05);
      overflow: hidden;
    }
    
    table {
      width: 100%;
      border-collapse: collapse;
    }
    
    th, td {
      padding: 12px 15px;
      text-align: left;
      border-bottom: 1px solid #e5e7eb;
    }
    
    th {
      background: #f8f9ff;
      font-weight: 600;
      color: #555;
      font-size: 13px;
      text-transform: uppercase;
      cursor: pointer;
      user-select: none;
    }
    
    th:hover { background: #e5e7eb; }
    th.sortable::after { content: ' ⇅'; opacity: 0.3; }
    th.sorted-asc::after { content: ' ↑'; opacity: 1; }
    th.sorted-desc::after { content: ' ↓'; opacity: 1; }
    
    td { color: #333; font-size: 14px; }
    tr:hover { background: #f8f9ff; }
    
    .user-slug {
      color: #667eea;
      text-decoration: none;
      font-family: monospace;
    }
    
    .user-slug:hover { text-decoration: underline; }
    .user-date { color: #6b7280; font-size: 12px; }
    .user-actions { display: flex; gap: 5px; }
    
    .pagination {
      padding: 15px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      border-top: 1px solid #e5e7eb;
    }
    
    .pagination-info { color: #6b7280; font-size: 14px; }
    .pagination-buttons { display: flex; gap: 5px; }
    
    .modal {
      display: none;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0,0,0,0.5);
      z-index: 1000;
      padding: 20px;
      overflow-y: auto;
    }
    
    .modal.active {
      display: flex;
      justify-content: center;
      align-items: start;
      padding-top: 50px;
    }
    
    .modal-content {
      background: white;
      padding: 30px;
      border-radius: 12px;
      width: 100%;
      max-width: 900px;
      max-height: 90vh;
      overflow-y: auto;
    }
    
    .modal-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 25px;
      padding-bottom: 15px;
      border-bottom: 2px solid #e5e7eb;
    }
    
    .modal-header h2 { color: #333; }
    
    .close-btn {
      background: none;
      border: none;
      font-size: 28px;
      cursor: pointer;
      color: #6b7280;
    }
    
    .form-section {
      margin-bottom: 25px;
      padding: 20px;
      background: #f8f9ff;
      border-radius: 8px;
    }
    
    .form-section h3 {
      margin-bottom: 15px;
      color: #333;
      font-size: 16px;
      display: flex;
      align-items: center;
      gap: 8px;
    }
    
    .form-row {
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 15px;
    }
    
    .link-row {
      display: flex;
      gap: 10px;
      margin-bottom: 10px;
      padding: 10px;
      background: white;
      border-radius: 8px;
    }
    
    .link-row select { flex: 0 0 150px; }
    .link-row input { flex: 1; }
    .link-row button { flex: 0 0 40px; }
    
    .module-item {
      background: white;
      border-radius: 8px;
      padding: 15px;
      margin-bottom: 10px;
    }
    
    .module-header {
      display: flex;
      align-items: center;
      gap: 10px;
      cursor: pointer;
      user-select: none;
    }
    
    .module-header input[type="checkbox"] {
      width: auto;
      cursor: pointer;
    }
    
    .module-header label {
      margin: 0;
      font-weight: 600;
      cursor: pointer;
      flex: 1;
    }
    
    .module-config {
      display: none;
      padding-top: 15px;
      margin-top: 15px;
      border-top: 2px solid #e5e7eb;
    }
    
    .module-config.active {
      display: block;
    }
    
    .checkbox-item {
      display: flex;
      align-items: center;
      gap: 10px;
      margin-bottom: 15px;
    }
    
    .checkbox-item input[type="checkbox"] {
      width: auto;
    }
    
    .checkbox-item label {
      margin: 0;
      font-weight: normal;
      cursor: pointer;
    }
    
    @media (max-width: 768px) {
      .header { flex-direction: column; gap: 15px; }
      .form-row { grid-template-columns: 1fr; }
      .tabs { flex-direction: column; }
      table { font-size: 12px; }
      th, td { padding: 8px; }
    }
  </style>
</head>
<body>
  <!-- LOGIN -->
  <div id="loginView" class="login-container">
    <div class="login-box">
      <h2>🔐 Admin Prijava</h2>
      <div id="loginError" class="error-message" style="display: none;"></div>
      <div class="form-group">
        <label>Korisničko ime / Email</label>
        <input type="text" id="loginUsername" placeholder="admin ili email@example.com">
      </div>
      <div class="form-group">
        <label>Lozinka</label>
        <div class="password-wrapper">
          <input type="password" id="loginPassword" placeholder="••••••••">
          <button type="button" class="password-toggle" onclick="togglePassword('loginPassword')">
            👁️
          </button>
        </div>
      </div>
      <div class="form-group">
        <label style="display: flex; align-items: center; gap: 8px; font-weight: normal; cursor: pointer;">
          <input type="checkbox" id="rememberMe" style="width: auto;">
          Zapamti me (30 dana)
        </label>
      </div>
      <button class="btn" onclick="handleLogin()">Prijavi se</button>
      <div class="back-link">
        <a href="#" onclick="showForgotPassword(); return false;">Zaboravili ste lozinku?</a>
      </div>
    </div>
  </div>

  <!-- FORGOT PASSWORD -->
  <div id="forgotPasswordView" class="login-container" style="display: none;">
    <div class="login-box">
      <h2>🔑 Zaboravljena lozinka</h2>
      <div id="forgotError" class="error-message" style="display: none;"></div>
      <div id="forgotSuccess" class="success-message" style="display: none;"></div>
      <div class="form-group">
        <label>Email adresa</label>
        <input type="email" id="forgotEmail" placeholder="vas@email.com">
      </div>
      <button class="btn" onclick="handleForgotPassword()">Pošalji reset link</button>
      <div class="back-link">
        <a href="#" onclick="showLogin(); return false;">← Natrag na prijavu</a>
      </div>
    </div>
  </div>

  <!-- RESET PASSWORD -->
  <div id="resetPasswordView" class="login-container" style="display: none;">
    <div class="login-box">
      <h2>🔒 Nova lozinka</h2>
      <div id="resetError" class="error-message" style="display: none;"></div>
      <div id="resetSuccess" class="success-message" style="display: none;"></div>
      <div class="form-group">
        <label>Nova lozinka</label>
        <div class="password-wrapper">
          <input type="password" id="newPassword" placeholder="Minimalno 6 znakova">
          <button type="button" class="password-toggle" onclick="togglePassword('newPassword')">
            👁️
          </button>
        </div>
      </div>
      <div class="form-group">
        <label>Potvrdi lozinku</label>
        <div class="password-wrapper">
          <input type="password" id="confirmPassword" placeholder="Ponovi lozinku">
          <button type="button" class="password-toggle" onclick="togglePassword('confirmPassword')">
            👁️
          </button>
        </div>
      </div>
      <button class="btn" onclick="handleResetPassword()">Promijeni lozinku</button>
      <div class="back-link">
        <a href="#" onclick="showLogin(); return false;">← Natrag na prijavu</a>
      </div>
    </div>
  </div>

  <!-- DASHBOARD - Ostatak kao hybrid verzija -->
  <div id="dashboardView" class="dashboard" style="display: none;">
    <!-- Cijeli dashboard content kao u hybrid verziji -->
  </div>

  <script>
    let currentToken = null;
    let resetToken = null;

    // Check za reset token u URL-u
    window.addEventListener('DOMContentLoaded', () => {
      const urlParams = new URLSearchParams(window.location.search);
      resetToken = urlParams.get('reset');
      
      if (resetToken) {
        showResetPassword();
      } else {
        checkAuth();
      }
    });
    
    function checkAuth() {
      currentToken = localStorage.getItem('token') || sessionStorage.getItem('token');
      
      if (currentToken) {
        document.getElementById('loginView').style.display = 'none';
        document.getElementById('dashboardView').style.display = 'block';
        // loadUsers(); itd...
      } else {
        showLogin();
      }
    }

    function showLogin() {
      document.getElementById('loginView').style.display = 'flex';
      document.getElementById('forgotPasswordView').style.display = 'none';
      document.getElementById('resetPasswordView').style.display = 'none';
      document.getElementById('dashboardView').style.display = 'none';
    }

    function showForgotPassword() {
      document.getElementById('loginView').style.display = 'none';
      document.getElementById('forgotPasswordView').style.display = 'flex';
      document.getElementById('resetPasswordView').style.display = 'none';
      document.getElementById('dashboardView').style.display = 'none';
    }

    function showResetPassword() {
      document.getElementById('loginView').style.display = 'none';
      document.getElementById('forgotPasswordView').style.display = 'none';
      document.getElementById('resetPasswordView').style.display = 'flex';
      document.getElementById('dashboardView').style.display = 'none';
    }

    function togglePassword(fieldId) {
      const field = document.getElementById(fieldId);
      const button = event.target;
      
      if (field.type === 'password') {
        field.type = 'text';
        button.textContent = '🙈';
      } else {
        field.type = 'password';
        button.textContent = '👁️';
      }
    }

    async function handleLogin() {
      const username = document.getElementById('loginUsername').value;
      const password = document.getElementById('loginPassword').value;
      const rememberMe = document.getElementById('rememberMe').checked;
      
      document.getElementById('loginError').style.display = 'none';
      
      if (!username || !password) {
        document.getElementById('loginError').textContent = 'Unesite korisničko ime i lozinku';
        document.getElementById('loginError').style.display = 'block';
        return;
      }
      
      try {
        const response = await fetch('/api.php/auth/login', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({ username, password, remember: rememberMe })
        });
        
        const data = await response.json();
        
        if (response.ok) {
          if (rememberMe) {
            localStorage.setItem('token', data.token);
          } else {
            sessionStorage.setItem('token', data.token);
          }
          checkAuth();
        } else {
          document.getElementById('loginError').textContent = data.error || 'Pogrešni podaci';
          document.getElementById('loginError').style.display = 'block';
        }
      } catch (error) {
        document.getElementById('loginError').textContent = 'Greška pri povezivanju';
        document.getElementById('loginError').style.display = 'block';
      }
    }

    async function handleForgotPassword() {
      const email = document.getElementById('forgotEmail').value;
      
      document.getElementById('forgotError').style.display = 'none';
      document.getElementById('forgotSuccess').style.display = 'none';
      
      if (!email || !email.includes('@')) {
        document.getElementById('forgotError').textContent = 'Unesite važeći email';
        document.getElementById('forgotError').style.display = 'block';
        return;
      }
      
      try {
        const response = await fetch('/api.php/auth/request-reset', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({ email: email })
        });
        
        const data = await response.json();
        
        document.getElementById('forgotSuccess').textContent = data.message + ' Provjerite email za reset link.';
        document.getElementById('forgotSuccess').style.display = 'block';
        
        document.getElementById('forgotEmail').value = '';
      } catch (error) {
        document.getElementById('forgotError').textContent = 'Greška pri slanju';
        document.getElementById('forgotError').style.display = 'block';
      }
    }

    async function handleResetPassword() {
      const newPassword = document.getElementById('newPassword').value;
      const confirmPassword = document.getElementById('confirmPassword').value;
      
      document.getElementById('resetError').style.display = 'none';
      document.getElementById('resetSuccess').style.display = 'none';
      
      if (newPassword.length < 6) {
        document.getElementById('resetError').textContent = 'Lozinka mora imati minimalno 6 znakova';
        document.getElementById('resetError').style.display = 'block';
        return;
      }
      
      if (newPassword !== confirmPassword) {
        document.getElementById('resetError').textContent = 'Lozinke se ne poklapaju';
        document.getElementById('resetError').style.display = 'block';
        return;
      }
      
      try {
        const response = await fetch('/api.php/auth/reset-password', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({ token: resetToken, password: newPassword })
        });
        
        const data = await response.json();
        
        if (response.ok) {
          document.getElementById('resetSuccess').textContent = data.message + ' Preusmjeravanje...';
          document.getElementById('resetSuccess').style.display = 'block';
          
          setTimeout(() => {
            window.location.href = '/admin.php';
          }, 2000);
        } else {
          document.getElementById('resetError').textContent = data.error || 'Greška';
          document.getElementById('resetError').style.display = 'block';
        }
      } catch (error) {
        document.getElementById('resetError').textContent = 'Greška pri promjeni lozinke';
        document.getElementById('resetError').style.display = 'block';
      }
    }

    // Ostale funkcije kao u hybrid verziji...
  </script>
</body>
</html>