<?php
// TEST FILE - admin-debug.php

echo "<h1>ADMIN DEBUG TEST</h1>";
echo "<hr>";

echo "<h2>1. PHP Info:</h2>";
echo "PHP Version: " . phpversion() . "<br>";
echo "Server: " . $_SERVER['SERVER_SOFTWARE'] . "<br>";
echo "<br>";

echo "<h2>2. Request Info:</h2>";
echo "REQUEST_URI: " . $_SERVER['REQUEST_URI'] . "<br>";
echo "SCRIPT_NAME: " . $_SERVER['SCRIPT_NAME'] . "<br>";
echo "<br>";

echo "<h2>3. File Check:</h2>";
if (file_exists('admin.php')) {
    echo "✅ admin.php EXISTS<br>";
    echo "Size: " . filesize('admin.php') . " bytes<br>";
    echo "Modified: " . date("Y-m-d H:i:s", filemtime('admin.php')) . "<br>";
    
    // Pročitaj prvih 20 linija
    $lines = file('admin.php');
    echo "<h3>First 20 lines of admin.php:</h3>";
    echo "<pre>";
    for ($i = 0; $i < min(20, count($lines)); $i++) {
        echo htmlspecialchars($lines[$i]);
    }
    echo "</pre>";
} else {
    echo "❌ admin.php DOES NOT EXIST!<br>";
}
echo "<br>";

echo "<h2>4. Config Check:</h2>";
if (file_exists('config.php')) {
    echo "✅ config.php exists<br>";
} else {
    echo "❌ config.php missing<br>";
}
echo "<br>";

echo "<h2>5. Headers Check:</h2>";
if (headers_sent()) {
    echo "⚠️ Headers already sent!<br>";
} else {
    echo "✅ Headers not sent yet<br>";
}
echo "<br>";

echo "<hr>";
echo "<p><a href='/admin.php'>Try loading admin.php</a></p>";
echo "<p><a href='/'>Back to home</a></p>";
?>
